#ifndef NIM_MOVE_SELECTOR_HPP
#define NIM_MOVE_SELECTOR_HPP

/* collect acceptable moves and chose one of them by random;
   this is done using the reservoir-sampling algorithm by
   Donald Knuth for the special case with one entry.
*/

#include "NimMove.hpp"
#include "UniformIntDistribution.hpp"

class NimMoveSelector {
   public:
      NimMoveSelector() : moves{0}, selected{}, uniform{} {
      }
      void add(NimMove move) {
	 ++moves;
	 if (moves == 1 || uniform.draw(moves) == 0) {
	    selected = move;
	 }
      }
      NimMove get() const {
	 return selected;
      }
      unsigned int get_count() const {
	 return moves;
      }
   private:
      unsigned int moves;
      NimMove selected;
      UniformIntDistribution uniform;
};

#endif
