#include <cmath>
#include <iostream>
#include <iterator>
#include "rootfinder.hpp"

int main() {
   double a, b;
   std::cout << "a = "; std::cin >> a;
   std::cout << "b = "; std::cin >> b;

   std::cout << "roots of sin(x):" << std::endl;
   std::ostream_iterator<double> outit(std::cout, "\n");
   get_roots(outit,
	 /* f = */ [](double x) { return sin(x); },
	 /* f' = */ [](double x) { return cos(x); },
	 /* f'' = */ [](double x) { return -sin(x); },
	 a, b, 1E-6);

   std::cout << "roots of j0(x):" << std::endl;
   get_roots(outit, j0, a, b, 1E-6);
}
